package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestDocumentTemplateDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		try {
			DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}
		
		List<DocumentTemplate> dtList = DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
	}

	@Test
	public void testTwo() throws Exception {
		try {
			DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}
		
		List<DocumentTemplate> dtList = DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);
		
		DocumentTemplate dt2 = DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(dt.getId());
		Assert.assertNotNull(dt2);
		Assert.assertEquals(dt2.getId(), dt.getId());
	}
		
}
